/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8237;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import ibm.nways.ras.RAS;

public class PortPollAction2
implements StatusMapper,
TableStatusNamer {
    private static String bundle = "ibm.nways.jdm8237.Resources";
    private static final int RASID = 4;
    private static final int RASSUB = 29;
    private static final int ENABLED = 1;
    private static final int DISABLED = 2;
    private static final int OPERATIONAL = 1;
    private static final int NOTOPERATIONAL = 2;
    private static final int NOTPRESENT = 3;
    private static final int UP = 1;
    private static final int DOWN = 2;
    private static final int MARGINAL = -1;
    private static final int ADMIN_DISABLED = -2;
    private static final int UNKNOWN = -3;

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (RAS.isEnabled(4, 29)) {
            RAS.trace(4, 29, this, "nameThatTableObject", "entering");
        }
        I18NString i18NString = new I18NString(bundle, "PortsTable");
        if (RAS.isEnabled(4, 29)) {
            RAS.trace(4, 29, this, "nameThatTableObject", "exit");
        }
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (RAS.isEnabled(4, 29)) {
            RAS.trace(4, 29, this, "nameThatObject", "entering");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundle, "HubPort", objectArray);
        if (RAS.isEnabled(4, 29)) {
            RAS.trace(4, 29, this, "nameThatObject", "exit");
        }
        return i18NMsgFormat;
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        int n;
        Object[] objectArray = statusModelInfo.getIndexes();
        Integer n2 = (Integer)statusModelInfo.get("BasicPortConfig.PortLink");
        Integer n3 = (Integer)statusModelInfo.get("BasicPortConfig.PortStatus");
        Integer n4 = (Integer)statusModelInfo.get("BasicPortConfig.PortMode");
        if (n3 == null) {
            n = -3;
        } else {
            n = n3;
            if (n4 == 2) {
                n = -2;
            } else if (n2 == 2 && n == 1) {
                n = -1;
            }
        }
        StatusAndExplain statusAndExplain = this.evaluateStpPortState(n, objectArray);
        if (RAS.isEnabled(4, 29)) {
            RAS.trace(4, 29, this, "calculateStatus", "newStatus = " + statusAndExplain.statType + " " + statusAndExplain.explain.getTranslation());
        }
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    private StatusAndExplain evaluateStpPortState(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[2];
        switch (n) {
            case 1: 
            case 3: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[0] = new I18NMsgFormat(bundle, "PortStatus", objectArray);
                objectArray2[1] = new I18NString(bundle, "NORMAL");
                break;
            }
            case -1: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[0] = new I18NMsgFormat(bundle, "PortStatus", objectArray);
                objectArray2[1] = new I18NString(bundle, "MARGINAL");
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray2[0] = new I18NMsgFormat(bundle, "PortStatus", objectArray);
                objectArray2[1] = new I18NString(bundle, "CRITICAL");
                break;
            }
            case -2: {
                statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                objectArray2[0] = new I18NMsgFormat(bundle, "PortStatus", objectArray);
                objectArray2[1] = new I18NString(bundle, "ADMIN");
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[0] = new I18NMsgFormat(bundle, "HubPort", objectArray);
                objectArray2[1] = new I18NString(bundle, "unknown");
            }
        }
        if (objectArray[1].equals(new Integer(18))) {
            objectArray2[0] = new I18NMsgFormat(bundle, "StackLinkIN", objectArray);
        } else if (objectArray[1].equals(new Integer(19))) {
            objectArray2[0] = new I18NMsgFormat(bundle, "StackLinkOUT", objectArray);
        }
        statusAndExplain.explain = new I18NGiblets(bundle, "PortStatusOrder", objectArray2);
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            PortPollAction2.this = PortPollAction2.this;
        }
    }
}

